


/******************************************************************************************
 *                                                                                        *
 *  Ex2.     :  Read ASCII ET-Matrix Key Decoder for Key PAD 4x4 and 4x3                  *
 *                  (Connect Key Pad 4x4 or 4x3 to KEY_IN1 or KEY_IN2)                    *
 *                                                                                        *
 ******************************************************************************************
 *                                                                                        *
 * Target MCU        : ATMEGA168(ET-BASE AVR EASY MEGA168)                                *
 *                   : X-TAL : 16 MHz                                                     *
 *                                                                                        *
 * Compiler Editor   : Arduino 1.0.4                                                      *
 * Create By         : Mr. Sittiphol Yooyod (WWW.ETT.CO.TH)                               *
 * Last Update       : 14/April/2015                                                   *
 *                                                                                        *
 * Port Interface    :  -- MCU-AT MEGA168--                                               *  
 *                                                                                        *   
 * I/P Uart0(Driver) :   D0 = TXDO          Connect            Rx ET-Matrix Key Decoder   *  
 *                       D1 = RXD0          Connect            Tx ET-Matrix Key Decoder   *
 *                       Baud Rate = 57600  at Clock 16 MHz                               *
 *                                                                                        *
 *                                                                                        *
 *  O/P Display Port :                                                                    *
 *                                                                                        *
 *               LED :   Connect Common Anode(LED Active Low)                             *
 *                       D14(A0)          Connect                 LED0  (BCD1-L)          *
 *                       D15(A1)          Connect                 LED1  (BCD2-L)          *
 *                       D16(A2)          Connect                 LED2  (BCD4-L)          *
 *                       D17(A3)          Connect                 LED3  (BCD8-L)          *
 *                       D18(A4)          Connect                 LED4  (BCD1-H)          *
 *                       D19(A5)          Connect                 LED5  (BCD2-H)          *
 *                                                                                        *
 *                                                                                        *
 *                                                                                        *
 *   Operation  : When Touch Key will                                                     *
 *                                    -Show ASCII(Hex) Key Code (Key0-9) To LED           *  
 *                                                                                        *
 *                                                                                        *
 ******************************************************************************************/

  unsigned char key[3] ,n=0                    ;


//------------Define O/P Port(D14..D19[A0..A5]) LED Display ASCII Code(Hex)------------

#define LED0          14     //D14(A0)   
#define LED1          15     //D15(A1)  
#define LED2          16     //D16(A2)  
#define LED3          17     //D17(A3)  
#define LED4          18     //D18(A4)  
#define LED5          19     //D19(A5)  


/*********************************************************************************
 **                                                                             **
 **           Read ASCII Key Code From RS232 ET-Matrix Key Decoder              **
 **                                                                             **
 *********************************************************************************/
 
void RD_KeyCode()
 {
   unsigned char ch ;
   
        if(Serial.available() > 0)      // send data only when you receive data:
          {                
            ch = Serial.read()    ;     //Read Ascii Key Code 1 byte
            key[n] = ch           ;
            n++                   ; 

            if(n == 3)                  //if Pointer= 3 Clear Pointer=0
               n=0                ;
	 }                              // End Receive data 

 }


/*##########################################################################
  ##                                                                      ##
  ##                               SETUP                                  ##
  ##                                                                      ##
  ##########################################################################*/



void setup() 
{ 


 //----------- Initial Port A0..A5 = Output LED for Display BCD Key Code
  
    pinMode(LED0,OUTPUT)                 ; //Set Status pin D14(A0) = Output   
    pinMode(LED1,OUTPUT)                 ; //Set Status pin D15(A1) = Output   
    pinMode(LED2,OUTPUT)                 ; //Set Status pin D16(A2) = Output   
    pinMode(LED3,OUTPUT)                 ; //Set Status pin D17(A3) = Output  
    pinMode(LED4,OUTPUT)                 ; //Set Status pin D18(A4) = Output  
    pinMode(LED5,OUTPUT)                 ; //Set Status pin D19(A5) = Output 
    
    
    digitalWrite(LED0,HIGH)              ; // Default set Output Port OFF LED 
    digitalWrite(LED1,HIGH)              ;
    digitalWrite(LED2,HIGH)              ;
    digitalWrite(LED3,HIGH)              ;
    digitalWrite(LED4,HIGH)              ;
    digitalWrite(LED5,HIGH)              ;
    

  //--------------------- Initial UART0 (D0=Tx ,D1=Rx)----------------------
 
    Serial.begin(57600)                  ; //Set Board Rate Uart0 =57600
  
}



/*#######################################################################
 ##                                                                    ##
 ##                        MAIN PROGRAM                                ##
 ##                                                                    ##
 #######################################################################*/
 

void loop() 
{ 
  char dd ;
  
   RD_KeyCode() ;                       //Step1: Read ASCII Code 3 Byte
     
   if(key[2] == 0x0D)                  //Step2: Check data Last Byte readded              
     {
        key[2] =0 ;                    //Step3: Clear data in buffer array key[2]
      
        if(key[0]=='P')                //Step4: Check  Status  Pressed key (ASCII Code = 'P')
         {
             //------ Step5 : Write Program Support Press Key of User ------ 

           if((key[1]>='0')&&(key[1]<='9'))       //Check Press Key '0'-'9'
             {    
              dd = ~key[1]                       ; //Convert Key Code for LED Common Anode(Active 0)
              digitalWrite(LED0,dd&0x01)         ; //Sent data LED0   
              dd = dd>>1                         ;       
              digitalWrite(LED1,dd&0x01)         ; //Sent data LED1   
              dd = dd>>1                         ;   
              digitalWrite(LED2,dd&0x01)         ; //Sent data LED2   
              dd = dd>>1                         ;
              digitalWrite(LED3,dd&0x01)         ; //Sent data LED3   
              dd = dd>>1                         ;
              digitalWrite(LED4,dd&0x01)         ; //Sent data LED4  
              dd = dd>>1                         ;
              digitalWrite(LED5,dd&0x01)         ; //Sent data LED5
 
            
              while(key[0] != 'R')        //wait Release Key (when key[0]=R) for Exit Loop   
               {
                 RD_KeyCode() ;                      
               }    
           
              digitalWrite(LED0,HIGH)            ; //SET LED0-OFF          
              digitalWrite(LED1,HIGH)            ; //SET LED1-OFF   
              digitalWrite(LED2,HIGH)            ; //SET LED2-OFF   
              digitalWrite(LED3,HIGH)            ; //SET LED3-OFF   
              digitalWrite(LED4,HIGH)            ; //SET LED4-OFF   
              digitalWrite(LED5,HIGH)            ; //SET LED5-OFF                 
           
            }//if key[1]
        }  //if key[0]
     }  //if key[2]       
}















